<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseRules;

class Ruleset extends \Google\Model
{
  /**
   * Immutable. Intended resource to which this Ruleset should be released. May
   * be left blank to signify the resource associated with the default release.
   * Expected format: firestore.googleapis.com/projects//databases/
   *
   * @var string
   */
  public $attachmentPoint;
  /**
   * Output only. Time the `Ruleset` was created.
   *
   * @var string
   */
  public $createTime;
  protected $metadataType = Metadata::class;
  protected $metadataDataType = '';
  /**
   * Output only. Name of the `Ruleset`. The ruleset_id is auto generated by the
   * service. Format: `projects/{project_id}/rulesets/{ruleset_id}`
   *
   * @var string
   */
  public $name;
  protected $sourceType = Source::class;
  protected $sourceDataType = '';

  /**
   * Immutable. Intended resource to which this Ruleset should be released. May
   * be left blank to signify the resource associated with the default release.
   * Expected format: firestore.googleapis.com/projects//databases/
   *
   * @param string $attachmentPoint
   */
  public function setAttachmentPoint($attachmentPoint)
  {
    $this->attachmentPoint = $attachmentPoint;
  }
  /**
   * @return string
   */
  public function getAttachmentPoint()
  {
    return $this->attachmentPoint;
  }
  /**
   * Output only. Time the `Ruleset` was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The metadata for this ruleset.
   *
   * @param Metadata $metadata
   */
  public function setMetadata(Metadata $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return Metadata
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * Output only. Name of the `Ruleset`. The ruleset_id is auto generated by the
   * service. Format: `projects/{project_id}/rulesets/{ruleset_id}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. `Source` for the `Ruleset`.
   *
   * @param Source $source
   */
  public function setSource(Source $source)
  {
    $this->source = $source;
  }
  /**
   * @return Source
   */
  public function getSource()
  {
    return $this->source;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Ruleset::class, 'Google_Service_FirebaseRules_Ruleset');
