<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecureSourceManager;

class Issue extends \Google\Model
{
  /**
   * Unspecified.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * An open issue.
   */
  public const STATE_OPEN = 'OPEN';
  /**
   * A closed issue.
   */
  public const STATE_CLOSED = 'CLOSED';
  /**
   * Optional. Issue body. Provides a detailed description of the issue.
   *
   * @var string
   */
  public $body;
  /**
   * Output only. Close timestamp (if closed). Cleared when is re-opened.
   *
   * @var string
   */
  public $closeTime;
  /**
   * Output only. Creation timestamp.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   *
   * @var string
   */
  public $etag;
  /**
   * Identifier. Unique identifier for an issue. The issue id is generated by
   * the server. Format: `projects/{project}/locations/{location}/repositories/{
   * repository}/issues/{issue_id}`
   *
   * @var string
   */
  public $name;
  /**
   * Output only. State of the issue.
   *
   * @var string
   */
  public $state;
  /**
   * Required. Issue title.
   *
   * @var string
   */
  public $title;
  /**
   * Output only. Last updated timestamp.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Optional. Issue body. Provides a detailed description of the issue.
   *
   * @param string $body
   */
  public function setBody($body)
  {
    $this->body = $body;
  }
  /**
   * @return string
   */
  public function getBody()
  {
    return $this->body;
  }
  /**
   * Output only. Close timestamp (if closed). Cleared when is re-opened.
   *
   * @param string $closeTime
   */
  public function setCloseTime($closeTime)
  {
    $this->closeTime = $closeTime;
  }
  /**
   * @return string
   */
  public function getCloseTime()
  {
    return $this->closeTime;
  }
  /**
   * Output only. Creation timestamp.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. This checksum is computed by the server based on the value of
   * other fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Identifier. Unique identifier for an issue. The issue id is generated by
   * the server. Format: `projects/{project}/locations/{location}/repositories/{
   * repository}/issues/{issue_id}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. State of the issue.
   *
   * Accepted values: STATE_UNSPECIFIED, OPEN, CLOSED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Required. Issue title.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
  /**
   * Output only. Last updated timestamp.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Issue::class, 'Google_Service_SecureSourceManager_Issue');
